//
//  SynchronizeViewController.swift
//  Demo iOS
//
//  Created by Benoit Vasseur on 05/07/2022.
//

import UIKit

class SynchronizeViewController: BaseViewController {

    @IBOutlet weak var pinField: UITextField!
    @IBOutlet weak var pinTitle: UILabel!
    @IBOutlet weak var syncButton: UIButton!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.title = "Synchronize"
        pinField.isHidden = true
        pinTitle.isHidden = true
        syncButton.isHidden = true

        startSynchronize()
    }
    
    func startSynchronize() {
        DispatchQueue.global().async {
            let result = InweboService.sharedInstance.startSynchronize()
            DispatchQueue.main.async {
                if (result == IW_ERR_OK) {
                    let pinMode = InweboService.sharedInstance.getPinMode()
                    self.pinField.isHidden = pinMode == IW_PINMODE_NONE
                    self.pinTitle.isHidden = pinMode == IW_PINMODE_NONE
                    self.syncButton.isHidden = false
                } else {
                    self.showErrorFor(code: result)
                    self.navigationController?.popViewController(animated: true)
                }
            }
        }
    }
    
    func finalizeSynchronize(pin: String) {
        DispatchQueue.main.async {
            let result = InweboService.sharedInstance.finalizeSynchronize(pin: pin)
            DispatchQueue.main.async {
                if (result == IW_ERR_OK) {
                    self.showAlert(title: "Synchronize", message: "Success", button1: (name: "OK", action: {
                        _ in
                        self.navigationController?.popViewController(animated: true)
                    }), button2: nil)
                } else {
                    self.showErrorFor(code: result)
                }
            }
        }
    }
    
    @IBAction func synchronizeTouched(_ sender: Any) {
        let pin = self.pinField.text ?? ""
        finalizeSynchronize(pin: pin)
    }
}
